/******************************************************************************
 * (C) Copyright 2000 by Agilent Technologies GmbH. All rights reserved.      *
 ******************************************************************************/

/* ---------------------------------------------------------------
 * File: xpattern.h
 * -----------------------------------------------------------------*/

#ifndef XPATTERN_H_INCLUDED
#define XPATTERN_H_INCLUDED

#include <xtypedef.h>
#include <xbddefs.h>

#ifndef CLI
#define CLI
#endif

#ifdef __cplusplus
extern "C" {
#endif
  

/* ---------------------------------------------------------------
 * Pattern terms
 * --------------------------------------------------------------- */

CLI bx_errtype EXPORT BestXPattProg(     /* @pattprog   */
  bx_handletype handle,
  bx_patttype prop,           
  bx_charptrtype pattern                  
);

CLI bx_errtype EXPORT BestXPattDefaultSet(     /* @pattdefset   */
  bx_handletype handle
);

CLI bx_errtype EXPORT BestXPattSet(     /* @pattset   */
  bx_handletype handle,
  bx_patttype   prop,           
  bx_charptrtype pattern                  
);

CLI bx_errtype EXPORT BestXPattGet(     /* @pattget   */
  bx_handletype handle,
  bx_patttype   prop,           
  bx_charptrtype *pattern  /* #RETURN "\"%s\"" */                 
);

#ifdef __cplusplus
}
#endif


#endif

